;;
RosAsm GUID Convertor v0.1a
Eric Asbell (RobotBob)
easbell@quanta-it.com
March 29th 2004

Convert GUIDs, in various formats, to a RosAsm compatable one.
(a GUID is a unique 128-bit integer used for CLSIDs and interface identifiers.)
GUID Convertor implemented as a dialogbox
;;

; Macros
[push | push #1 | #+1]  
[pop | pop #1 | #+1]     
[call | push #L>2 | call #1]

;Dialog Related
[DialogID: 1000]
[DialogHandle: D$ 0]
[hInstance: D$ 0]
[ConvertButton 105]
[InputBox 101]
[ResultBox 102]
[FormatRegistry 103]
[FormatOther 104]
[GUIDNameBox 106]
[hDlg: D$ 0]

;GUID template
[GUIDSTRUCT: B$ "@Data1: D$ 0xxxxxxxxH
@Data2: W$ 0xxxxH
@Data3: W$ 0xxxxH]
[@Data4: B$ 0xx 0xx 0xx 0xx 0xx 0xx 0xx 0xx]" 0]

[FormatCharLeftBracket: B$ '[' 0
FormatCharColon:  B$ ':' 13 10 0]

;Error Msgs
[APPNAME: B$ 'Guid Convertor v0.1a' 0]
[GUIDEmptyErr: B$ 'You must place a GUID string into the editbox' 0]
[GUIDNameBoxErr: B$ 'You must specify a name for this GUID' 0]

;Misc
[ConversionFormat: D$ 0]
[TypeRegistry 1]
[TypeOther 2]

Main:       
        call 'Kernel32.GetModuleHandleA' 0 | mov D$hInstance eax                      
        call 'USER32.DialogBoxParamA'  0 1000 0 DialogProc 0 | mov D$DialogHandle eax
        call 'KERNEL32.ExitProcess' 0
        ret
____________________________________________________________________________________________


DialogProc:
     
    push ebp
    mov ebp esp

    pushad
    cmp D$ebp+12 &WM_INITDIALOG
    jne L1>
        call 'USER32.CheckRadioButton' D$ebp+8 FormatRegistry FormatOther FormatRegistry  ;Default First Radio
    jmp L9>>
L1:
    cmp D$ebp+12 &WM_COMMAND
    jne L1>>
            cmp D$ebp+16 ConvertButton        
            jne L1>>
            
                call CreateBuffers
                
                call 'USER32.GetDlgItemTextA' D$ebp+8 InputBox D$GUIDTextBufferA 255
                cmp eax 0
                jne L2>
                    call 'USER32.MessageBoxA' 0 GUIDEmptyErr APPNAME 0
                jmp L9>>
                
L2:             call 'USER32.GetDlgItemTextA' D$ebp+8 GuidNameBox D$GUIDNAME 50                
                cmp eax 0
                jne L2>
                    call 'USER32.MessageBoxA' 0 GUIDNameBoxErr APPNAME 0
                jmp L9>>
L2:             
                call 'USER32.IsDlgButtonChecked' D$ebp+8 FormatRegistry
                cmp eax &BST_CHECKED
                jne L2>                
                call ConvertGUID
L2:                              
                call 'USER32.SetDlgItemTextA' D$ebp+8 ResultBox D$ResultBuffer
                
                call FreeBuffers
            jmp L9>>
            
L2:         cmp D$ebp+16 FormatRegistry
            jne L2>
                mov D$ConversionFormat TypeRegistry
                
            jmp L9>>
L2:           
           
L1: cmp D$ebp+12 &WM_CLOSE
    jne L1>
          
    call 'User32.EndDialog' D$ebp+8 &TRUE
        
    jmp L9>
L1:
    
    ;...
    
L9: 
    popad
    mov eax &FALSE
    
    mov esp ebp
    pop ebp
    ret 16


___________________________________________________________________________________________


; --------------------------------
; GUID conversion code below
;---------------------------------


ConvertGUID:
        call 'KERNEL32.lstrcpy' D$GUIDSTRUCTBuffer GUIDSTRUCT
              
        call 'KERNEL32.lstrcpy' D$ResultBuffer FormatCharLeftBracket
        call 'KERNEL32.lstrcat' D$ResultBuffer D$GUIDNAME
        call 'KERNEL32.lstrcat' D$ResultBuffer FormatCharColon
        
        ; Take out the bytes we dont want
        call RemoveChar D$GUIDTextBufferA D$GUIDTextBufferA 07B
        call RemoveChar D$GUIDTextBufferA D$GUIDTextBufferA 07D
        call RemoveChar D$GUIDTextBufferA D$GUIDTextBufferA 02D
        
        ; Just in case a semi colon is there (comment)
        call RemoveChar D$GUIDTextBufferA D$GUIDTextBufferA 03B
                                
        ; OK sane replace from decimal ascii list to our GUID template       
        mov esi D$GUIDTextBufferA
        mov edi D$GUIDSTRUCTBuffer ;GUIDSTRUCT
        
L1:                
        mov al B$edi
        cmp al 078      ; is the destination byte a 'x'? if so -->L2
        je L2>
        inc edi         ; It wasn't an 'x' increment edi
        jmp L1< 
L2:     
        mov al B$esi    ; Since we found an 'x' we can copy a byte over.
        mov B$edi al
        
        inc esi         ; And continue...
        inc edi
        
        mov al B$esi    ; Is the source byte a null? if so we are done.
        cmp al 00
        jne L1< 
        
        call 'KERNEL32.lstrcat' D$ResultBuffer D$GUIDSTRUCTBuffer ;GUIDSTRUCT
        
        ret
        
        
____________________________________________________________________________________________


RemoveChar:
        ;arg1=Inbound, Arg2=OutBound, Arg3=CharToRemove
        push ebp
        mov ebp esp
        pushad

        mov esi D$ebp+8         ; move 1st arg into source
        mov edi D$ebp+12        ; move 2nd arg into destination
                   
L1:
        mov al B$esi            ; copy byte at address in esi to al
        inc esi                 ; increment address in esi
        mov B$edi al            ; copy byte in al to address in edi
        
        ; If Found then do not increment edi, it will cause the byte we wish to
        ; remove to be skipped in the copy.
                
        cmp al B$ebp+16         ; compare a byte
        jne L2>                 ; If equal then do the next line
        jmp L3>                 ; unconditionally jmp to L3 to skip inc edi
               
L2:     inc edi                ; increment address in edi
L3:     cmp al, 0              ; see if its an ascii zero (null terminated string)
        jne L1<                ; jump back and read next byte if not
        
                
        popad                                         
        mov esp ebp
        pop ebp
        ret 12



____________________________________________________________________________________________


;Input Buffer
[GUIDTextBufferW: D$ 0]        ;255
[GUIDTextBufferA: D$ 0]        ;255
[ResultBuffer: D$ 0]           ;800
[GUIDNAME: D$ 0]               ;50
[GUIDSTRUCTBuffer: D$ 0]       ;50

CreateBuffers:
            
            call 'KERNEL32.GlobalAlloc' &GPTR 255
            mov D$GUIDTextBufferA eax
            
            call 'KERNEL32.GlobalAlloc' &GPTR 800
            mov D$ResultBuffer eax
            
            call 'KERNEL32.GlobalAlloc' &GPTR 50
            mov D$GUIDNAME eax
            
            call 'KERNEL32.GlobalAlloc' &GPTR 150
            mov D$GUIDSTRUCTBuffer eax

            ret
            
            
FreeBuffers:

        call 'KERNEL32.GlobalFree' D$GUIDTextBufferA 
        call 'KERNEL32.GlobalFree' D$ResultBuffer 
        call 'KERNEL32.GlobalFree' D$GUIDNAME 
        call 'KERNEL32.GlobalFree' D$GUIDSTRUCTBuffer 

        ret

